package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets;

import org.apache.log4j.Logger;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Modification de l'attribut CKA_VALUE d'un objet de donnes applicatives
 *
 */
public class ModificationAttributObjet{
	
	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(ModificationAttributObjet.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param idObjet Identifiant de l'obket
	 * @param libelle Libell de l'objet
	 * @param donnees Donnes applicatives de l'objet
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, long idObjet, String libelle, String donnees) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {
			
				Resultat resultat = null;
				
				if(donnees != null) {		
		
					resultat = new Resultat("Modification de l'attribut CKA_VALUE de l'objet \""+libelle+"\" (C_SetAttributeValue)");			
		
					// Construction de l'objet
					CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[1];
					attributes[0] = new CK_ATTRIBUTE();
					attributes[0].type = PKCS11Constants.CKA_VALUE;				
					attributes[0].pValue = TraitementsUtil.getOctetsSansFormatage(donnees);
				
					try {
						
						// Traitements  tester
						librairie.C_SetAttributeValue(idSession, idObjet, attributes);
						
					} catch (PKCS11Exception e) {
						
						log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
						resultat.setCodeRetour(e.getErrorCode());
						
					}
					
				} else {
					
					// Si les donnes sont nulles il est impossible de raliser l'opration
					log.error("Les donnes applicatives sont nulles");
					throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_MODIF_ATTRIBUT, "Les donnes applicatives sont nulles");
					
				}
				
				return resultat;
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_MODIF_ATTRIBUT, "La librairie est nulle");
				
			}
	
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_OBJETS_MODIF_ATTRIBUT, "Une erreur inattendue est survenue");
			
		}

	}
}
